#!/bin/sh
#
#  Copyright (c) 1997,1998, Xylan Corp.
#
#  Version 3.3 - xvision
#
#  Installs the Xylan XVision software and registers with the Network
#  Manager if there is one.
#
#  Future Release Modifications Required: The current release is 3.3, thus
#  I am using the env var XVISION_33. For the next release, if it is
#  incompatable with this one, then use a different env var, say XVISION_331.
#  Then everywhere in this script where we say XVISION_33, replace with
#  XVISION_331.
#  Also, change the statement "XVVERS=3.3" to "XVVERS=3.4", or whatever the
#  version is.
#  This mechanism helps ensure that different versions of Xylan software dont
#  interfere with each other, giving unexpected results at the customer site.
#
# ARGS: see Usage below

ExitMsg()
{
    echo "\nThanks for choosing $XVOEM!" 
    exit 0
}

UnTarXvis()
{
    echo "\n***********************" 
    echo "Extracting $XVOEMXV ..." 
    # untar the 3rd party exec's and dll's 
    #
    uncompress ${USERDIR}/xvwu$ARCH.tar.Z
    tar xof ${USERDIR}/xvwu$ARCH.tar
	rm ${USERDIR}/xvwu$ARCH.tar
    #compress ${USERDIR}/xvwu$ARCH.tar
    cp WindU .WindU
	rm -f libodbc42.$XVSUFF

    # untar Xylan dll's, exec's, etc.
    #
    uncompress ${USERDIR}/xvis$ARCH.tar.Z
    tar xof ${USERDIR}/xvis$ARCH.tar
	rm ${USERDIR}/xvis$ARCH.tar
    #compress ${USERDIR}/xvis$ARCH.tar
    uncompress ${USERDIR}/xvhelp.tar.Z
    tar xof ${USERDIR}/xvhelp.tar
    rm ${USERDIR}/xvhelp.tar

	# handle the sybase database stuff
    uncompress ${USERDIR}/xvsyb$ARCH.tar.Z
    tar xof ${USERDIR}/xvsyb$ARCH.tar
	rm ${USERDIR}/xvsyb$ARCH.tar
    #compress ${USERDIR}/xvsyb$ARCH.tar
    CURDIR=`pwd`
	echo $CURDIR | sed 's/\//\\\//g' > tmpodbc
	ODBCHOME=`cat tmpodbc`
	sed s/PATH/$ODBCHOME/g odbc.ini > odbc.ini2
	# replace libodbc with the sybase lib
	SYBDB="saodbc_r.so.1"
	if [ "$ARCH" = "sol2" ]
	then
		SYBDB="saodbc.so.1"
	elif [ "$ARCH" = "hp700mt" ]
	then
		SYBDB="saodbc.sl.1"
	fi
	sed s/saodbc_so/$SYBDB/g odbc.ini2 > .odbc.ini
	chmod 666 .odbc.ini
	ln -s $SYBDB libodbc42.$XVSUFF

    # Move database stuff into database directory and config files to the places
    # the self registration will set the registry to.
    #
	cp vlan.vln vlantemplate.vln
	chmod 777 xvsb.db vlan.vln vlantemplate.vln
	# set the set-user-id bit so that all users may have permission to ping
	# when using discovery, etc.
    USER=`whoami`
	if [ "$USER" = "root" -a "$ARCH" = "hp700mt" ]
	then
		chmod u+s xvision switchmanager 
		chmod u+s dbeng50 windu* regedit
	elif [ "$USER" = "root" ]
	then
		chmod u+s dbeng50 xvgensvc
	fi

    cp -f MIBComm.EVS    ../..
    cp -f SMLayout.CFG   ../..
    cp -f SMOEM.CFG      ../..
	ln -s ../../SMOEM.CFG ../../SMOem.cfg
    cp -f SwitchMg.TRAP  ../..
    # cp -f Updating.AVI   ../..
    cp -f SFReqList.INI  ../..
    cp -f Polling.avi    ../..
    cp -f Search9.avi    ../..
    cp -f ChassisSearch.avi    ../..
	ln -s ../../ChassisSearch.avi ../../ChassisSearch.AVI

    mv    Help           ../..
    CURDIR=`pwd`
#    cd    ../../Help
#    $USERDIR/xvrecurslow.sh $USERDIR
    cd    $CURDIR

    # if exists the libC.* shared libs, then delete it from here 
    #
    if [ "$ARCH" = "sol2" ]
    then
        for lib in libC.* 
        do
            if [ -x /usr/lib/$libc ]
            then
                rm $lib
            fi
        done
    elif [ "$ARCH" = "hp700mt" ]
    then
		# make links, since HP regsvr behaves strangely for registering libs
		ln -s ddinterfaces.tlb libddinterfaces.tlb
		ln -s systemservices.tlb libsystemservices.tlb
		ln -s xyatinterface.tlb libxyatinterface.tlb
		ln -s xyndinterface.tlb libxyndinterface.tlb
		ln -s xynminterface.tlb libxynminterface.tlb
		ln -s xysfinterface.tlb libxysfinterface.tlb
		ln -s xysminterface.tlb libxysminterface.tlb
		ln -s xyxvinterface.tlb libxyxvinterface.tlb
    fi
}

# untar Network Manager integration package
#
UnTarNMgr()
{
    uncompress ${USERDIR}/xvnm$ARCH.tar.Z
    tar xof ${USERDIR}/xvnm$ARCH.tar
	rm ${USERDIR}/xvnm$ARCH.tar
    #compress ${USERDIR}/xvnm$ARCH.tar
    echo "\n************************************************************************" 
    if [ "${NMGRSUPPORT}" = "netonly" -o "${NMGRSUPPORT}" = "netmgr" ]
    then
        echo "The following message pertains to integration with Network Managers:" 
    fi
	if [ "${XVOEM}" = "Xylan" ]
	then
    	echo "$XVOEMXV will use the file $HOME/communitystrings.ini when launched by a" 
    	echo "Network Manager under the following conditions:" 
    	echo " - there are no command line parameters -ro and -rw" 
    	echo " - if HPOV is not present" 
    	echo "The communitystrings.ini file is placed by default to \$HOME directory." 
    	echo "If other users wish to use it, they will have to have a copy of it in their \$HOME directory." 

    	if [ ! -f $HOME/communitystrings.ini ]
    	then
        	cp  communitystrings.ini $HOME
        	echo "Please see the file $HOME/communitystrings.ini. You may change it to suit" 
        	echo "your needs, or feel free to delete it entirely." 
    	else
        	echo "Please see the example file communitystrings.ini in $XVISION_33" 
    	fi
    fi
}


# USAGE - commandline verification
#
Usage()
{
    echo "ERROR: usage: $0 -instpath <install-path> -platform <platform> " 
    echo "              -platvers <platform version> -fresh <fresh | no | reconf>"
    echo "              [-netmgr <netmgr | netonly | no>] [-browser <html-browser>]"
    echo "     -instpath : is the target root path to install $XVOEMXV in" 
    echo "     -platform : is one of \"HP-UX\", \"AIX\", \"SunOS\" " 
    echo "     -platvers : ex: for SunOS, \"5.5\" " 
    echo "     -fresh    : either \"fresh\"(uses tar files) or \"reconf\"(reconfiguration because $XVOEMXV root directory was moved)" 
    echo "     -netmgr   : specify \"netmgr\" if integration with a network manager is desired" 
    echo "     -browser  : specify name or path to your browser (default: netscape)" 
    exit 1
}


CURPATH=`pwd`
INSTALLPATH="."
PLATFORM="unknown"
PLATVERS="unknown"
FRESHINSTALL="fresh"
NMGRSUPPORT="no"
USERHELPBROWSER="netscape"
XVOEMSM="SwitchManager"
XVOEMXV="X-Vision"
XVOEM="Xylan"
XVISSM_SH="xvissm.sh"
XVISRUN_SH="xvisrun.sh"
XVISLAUNCH_SH="xvislaunch.sh"


while [ "$#" -ge 1 ]
do
    case $1 in
    -instpath) shift; INSTALLPATH=$1 ;;
    -platform) shift; PLATFORM=$1 ;;
    -platvers) shift; PLATVERS=$1 ;;
    -fresh) shift; FRESHINSTALL=$1 ;;
    -netmgr) shift; NMGRSUPPORT=$1 ;;
    -browser) shift; USERHELPBROWSER=$1 ;;
    -oemsm) shift; XVOEMSM=$1 ;;
    -oemxv) shift; XVOEMXV=$1 ;;
    -oem) shift; XVOEM=$1 ;;
    -oemsmsh) shift; XVISSM_SH=$1 ;;
    -oemxvsh) shift; XVISRUN_SH=$1 ;;
    -oemsmlsh) shift; XVISLAUNCH_SH=$1 ;;
    *) ;;
    esac
    shift
done


echo "Installing for platform $PLATFORM in $INSTALLPATH" 
ARCHFLAG=" "
ARCH="ERROR"
case $PLATFORM in
HP-UX) case $PLATVERS in
	   *.10.*) ARCH=hp700mt ; ARCHFLAG="-hp" ; XVSUFF="sl" ;;
	   *.11.*) ARCH=hp700mt ; ARCHFLAG="-hp" ; XVSUFF="sl" ;;
       esac
;;
AIX)   ARCH=rs6000 ; ARCHFLAG="-aix" ; XVSUFF="a"
;;
SunOS) case $PLATVERS in
	     5.*) case "`uname -p`" in
	          sparc) ARCH=sol2 ; XVSUFF="so" ;;
	              *) ARCH=ERROR ;;
              esac
           ;;
           *) ARCH=ERROR ;;
       esac
;;
*)     ARCH=ERROR ;;
esac

if [ "$ARCH" = "ERROR" ]
then
    Usage $0
fi


# Go to installation dir
#
USERDIR=`pwd`
cd $INSTALLPATH

# set the .xvvars file with the ARCH and INSTALLPATH info and generated files 
#
echo "ARCH=${ARCH}" > .xvvars.sh
echo "export ARCH" >> .xvvars.sh
echo "XVOEMXV=${XVOEMXV}" >> .xvvars.sh
echo "export XVOEMXV"  >> .xvvars.sh
echo "XVISRUN_SH=${XVISRUN_SH}" >> .xvvars.sh
echo "export XVISRUN_SH"  >> .xvvars.sh
echo "XVISSM_SH=${XVISSM_SH}" >> .xvvars.sh
echo "export XVISSM_SH"  >> .xvvars.sh
echo "XVISLAUNCH_SH=${XVISLAUNCH_SH}" >> .xvvars.sh
echo "export XVISLAUNCH_SH"  >> .xvvars.sh

XVVERS=3.3
mkdir -p $XVOEMXV/$XVVERS
chmod 775 $XVOEMXV/$XVVERS
cd ${XVOEMXV}/$XVVERS

# now set INSTALLPATH for use later as the root path to {Database, System}
#
INSTALLPATH=`pwd`


XVISION_33=$INSTALLPATH/System/$ARCH
export XVISION_33
mkdir -p $XVISION_33
cd $XVISION_33
chmod 777 $INSTALLPATH/System $XVISION_33

# user must set the XVISION_33 to this path
#
#echo "\n********************************************************************************" 
#echo "See the file $XVISRUN_SH when installation is complete to see what your environment variable ${XVOEM}VISION_33 should be set to." 

#
# untar software
# 
if [ "${FRESHINSTALL}" = "fresh" ]
then
    UnTarXvis
fi

#
# end of tar work
#


# install network manager support if desired
#
cd $XVISION_33

# untar net mgr files and prepare certain files for this platform
#
UnTarNMgr
if [ "$ARCH" = "sol2" ]
then
	sed s/SWITCHMG_HOME/${XVOEM}VISION_33/g snm/switchmg_$ARCH.schema > snm/switchmg_1.schema
	sed s/xvislaunch.sh/$XVISLAUNCH_SH/g snm/switchmg_1.schema > snm/switchmg_2.schema
	sed s/xvissm.sh/$XVISSM_SH/g snm/switchmg_2.schema > snm/switchmg_3.schema
	sed s/SwitchManagerOem/$XVOEMSM/g snm/switchmg_3.schema > snm/switchmg.schema
	chmod +w snm/switchmg_*.schema
	rm snm/switchmg_*.schema
fi

# oemize OV stuff
sed s/SWITCHMG_HOME/${XVOEM}VISION_33/g ov/switchmg_$ARCH.reg > ov/switchmg_1.reg
sed s/SwitchManagerOem/$XVOEMSM/g ov/switchmg_1.reg > ov/switchmg_2.reg
sed s/XVisionOem/$XVOEMXV/g ov/switchmg_2.reg > ov/switchmg_3.reg
sed s/xvislaunch.sh/$XVISLAUNCH_SH/g ov/switchmg_3.reg > ov/switchmg_4.reg
sed s/XylanOem/$XVOEM/g ov/switchmg_4.reg > ov/switchmg.reg
chmod +w ov/switchmg_*.reg
rm ov/switchmg_*.reg

sed s/SwitchManagerOem/$XVOEMSM/g ov/switchmg.fields > ov/switchmg.fields1
chmod +w ov/switchmg.fields
sed s/XylanOem/$XVOEM/g  ov/switchmg.fields1 > ov/switchmg.fields
sed s/SwitchManagerOem/$XVOEMSM/g ov/switchmg.vendor > ov/switchmg.vendor1
chmod +w ov/switchmg.vendor
sed s/XylanOem/$XVOEM/g  ov/switchmg.vendor1 > ov/switchmg.vendor
sed s/SwitchManagerOem/$XVOEMSM/g ov/switchmg.oid > ov/switchmg.oid1
chmod +w ov/switchmg.oid
sed s/XylanOem/$XVOEM/g  ov/switchmg.oid1 > ov/switchmg.oid
sed s/SwitchManagerOem/$XVOEMSM/g ov/switchmg.sym > ov/switchmg.sym1
chmod +w ov/switchmg.sym
mv ov/switchmg.sym1 ov/switchmg.sym

# oemize Cabletron stuff
sed s/SWITCHMG_HOME/${XVOEM}VISION_33/g spectrum/spectrum/spectrum.2 > spectrum/spectrum/spectrum.fix
chmod +w spectrum/spectrum/spectrum.2
mv spectrum/spectrum/spectrum.fix spectrum/spectrum/spectrum.2

# find out what the nmlaunch link should be
if [ -d /usr/OV -o -d /opt/OV ]
then
	# assuming HPOV 5.n
	ln -s nmlaunchov nmlaunch
else
	ln -s nmlaunchgen nmlaunch
fi
if [ "$USER" = "root" -a "$ARCH" = "hp700mt" ]
then
	chmod u+s nmlaunch* 
fi

if [ "${NMGRSUPPORT}" = "netonly" -o "${NMGRSUPPORT}" = "netmgr" ]
then
# install network manager software from: xvnm$ARCH.tar
	echo "\n*********************************************"
	echo "Network manager integration about to begin...."

	SWITCHMG_HOME=$XVISION_33
	export SWITCHMG_HOME

	echo "\nIf Network manager integration fails, use $XVISION_33/switchmg_nms_setup to try again"
	echo "after fixing the original problem. You must be user 'root' to perform this integration."
#	echo "Make sure your environment variable \"${XVOEM}VISION_33\" is set to $XVISION_33"
	switchmg_nms_setup

	if [ "${NMGRSUPPORT}" = "netonly" ]
	then
		ExitMsg
	fi
else
	if [ "${XVOEM}" = "Xylan" ]
	then
   	 echo You may use the installation script "$XVISION_33/switchmg_nms_setup" to perform
		echo Network Manager integration at a later time.
#		echo "Make sure your environment variable \"${XVOEM}VISION_33\" is set to $XVISION_33"
	fi
fi


echo "" 

# set up registry, we want it shared by all users 
#
WINDU=$XVISION_33/.WindU
export WINDU
WUHOME=$XVISION_33
export WUHOME
SHELL=sh
export SHELL
HOSTNAME=`hostname`
export HOSTNAME
XMFILE="${XVISION_33}/.xv.${HOSTNAME}.sh"
cd $XVISION_33
${USERDIR}/xvgetpaths.sh $ARCH $XMFILE
if [ "$?" -ne 0 ]
then
    echo "ERROR: environment may not be set up right!" 
fi

# load these env vars so we can run the registry tools
#
. $XMFILE

DYNLIBPATH="LD_LIBRARY_PATH"
if [ "$ARCH" = "sol2" ]
then
    LD_LIBRARY_PATH=$XVISION_33:$WINDU_XMLIB_DIR:$WINDU_XLIB_DIR:/usr/openwin/lib:/usr/dt/lib:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    DYNLIBPATH="LD_LIBRARY_PATH"
elif [ "$ARCH" = "hp700mt" ]
then
    SHLIB_PATH=$XVISION_33:$WINDU_XMLIB_DIR:$WINDU_XLIB_DIR:/usr/openwin/lib:/usr/dt/lib:/usr/lib/X11R6:/usr/lib/X11R4:$SHLIB_PATH
    export SHLIB_PATH
    DYNLIBPATH="SHLIB_PATH"
	# if HP, then need to create a dir if not existing - need to be root
    if [ ! -d /usr/lib/aCC ]
	then
		mkdir -p /usr/lib/aCC
		chmod 755 /usr/lib/aCC
	fi
    if [ ! -x /usr/lib/aCC/dld.sl ]
	then
		cp $XVISION_33/dld.sl /usr/lib/aCC
		chmod 555 /usr/lib/aCC/dld.sl
	fi
    if [ ! -x /usr/lib/libstd.1 ]
	then
		ln -s libstd.1 libstd.sl
		ln -s libstream.1 libstream.sl
		ln -s libCsup.1 libCsup.sl
	fi
elif [ "$ARCH" = "rs6000" ]
then
    LIBPATH=$XVISION_33:$WINDU_XMLIB_DIR:$WINDU_XLIB_DIR:/usr/openwin/lib:/usr/dt/lib:/usr/lib:$LIBPATH
    export LIBPATH
    DYNLIBPATH="LIBPATH"
fi


PATH=$XVISION_33:$PATH
export PATH



# load the registry
#
cd $WUHOME
windu_registry start -system -dir $XVISION_33 -d $XVISION_33
if [ "$?" -ne 0 ]
then
    echo "ERROR: environment not set up correctly. Installation failed." 
    exit 1
fi

# create a .reg to specify where the OEM.cfg and Layout.cfg are
#    X-Vision/SwitchManager/WebBrowser="$WEBPATH/netscape"
#    X-Vision/HelpPath/SwitchManager="$HOME/Help"
#
cat << EOM > xycfg.reg
REGEDIT4

[HKEY_LOCAL_MACHINE\Software\XylanOem]

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"HelpPath"="$INSTALLPATH/Help"

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"WebBrowser"="$USERHELPBROWSER"

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"MIBDatabase"="$INSTALLPATH/System/$ARCH/xvsb.db"

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"VLANDatabase"="$INSTALLPATH/System/$ARCH/vlan.vln"

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"VLANUntitled"="$INSTALLPATH/System/$ARCH/vlantemplate.vln"

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"ATStatusBufferSize"=dword:28

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"ATStageChange"=dword:1

[HKEY_LOCAL_MACHINE\Software\XylanOem\XVisionOem]
"RTStageChange"=dword:1

EOM

sed s/XVisionOem/$XVOEMXV/g xycfg.reg > xycfg2.reg
sed s/XylanOem/$XVOEM/g xycfg2.reg > xycfg3.reg
mv xycfg3.reg xycfg.reg

# set up this env var in case the host has a decimal place in its name,
# this way Wind/U will behave properly (ex: manager.lab would be cut to manager
# unless we set the env var WINDU_REGISTRY_HOST)

WINDU_REGISTRY_HOST=$HOSTNAME
export WINDU_REGISTRY_HOST

regedit -s wuole.reg 
echo "Registering $XVOEMXV shared objects into the registry..."
$CURPATH/regocx.sh -s $ARCHFLAG
regedit  -s xycfg.reg 
# do it again, since seems to fail occasionally on AIX box
regedit  -s xycfg.reg 

# must make sure registry database is usable by all in the same group
#
chmod 777 .windu.*
chmod 777 .windu.*/*

# set up script for user (an sh that can be run by the others)
# set up users environment: startup script, link to registry
# want all users to use the same registry

export INSTALLPATH

cat << EOM > $XVISRUN_SH
#!/bin/sh
#
# $XVOEMXV 3.3 - Sets up the users environment and runs xvision.
#
# set your ${XVOEM}VISION_33 environment var to $XVISION_33
# example: % setenv ${XVOEM}VISION_33 $XVISION_33

${XVOEM}VISION_33=$XVISION_33
export ${XVOEM}VISION_33

WUHOME=\$${XVOEM}VISION_33
export WUHOME

WINDU=\$${XVOEM}VISION_33/.WindU
export WINDU

$DYNLIBPATH=\$${XVOEM}VISION_33:$WINDU_XMLIB_DIR:$WINDU_XLIB_DIR:/usr/openwin/lib:/usr/dt/lib:/usr/lib/X11R6:/usr/lib/X11R4:/usr/lib:\$$DYNLIBPATH
export $DYNLIBPATH

PATH=\$${XVOEM}VISION_33:$PATH:\$PATH
export PATH

WINDU_REGISTRY_HOST=\`hostname\`
export WINDU_REGISTRY_HOST

if [ -z "\$LANG" ]
then
	LANG="C"
	export LANG
fi

cd \$WUHOME
ps -eaf | grep windu_ | grep registryd4 >/dev/null
if [ "\$?" -ne 0 ]
then
    windu_registry start -system -dir \$WUHOME -d \$WUHOME
fi

if [ $ARCH != "hp700mt" ]
then
  ps -eaf | grep xvgen | grep svc >/dev/null
  if [ "\$?" -ne 0 ]
  then
      xvgensvc &
  fi
fi

chmod 777 xvsb.db vlan.vln 2>/dev/null
rm -f sb.log 2>/dev/null

XVHOST="ver3.3"
XVIPADD=unknown
XVGETPW=public
XVSETPW=public

while [ "\$#" -ge 1 ]
do
    case \$1 in
    -ro) shift; XVGETPW=\$1 ;;
    -rw) shift; XVSETPW=\$1 ;;
    -host) shift; XVHOST=\$1 ;;
    -ip) shift; XVIPADD=\$1 ;;
    *)
        if [ "\${XVHOST}" = "ver3.3" ]
        then
        XVHOST=\$1
        fi
        if [ "\${XVIPADD}" = "unknown" ]
        then
            XVIPADD=\$1
        fi
    esac
    shift
done

# start database engine if not running
ps -ea | grep dbeng | grep 50 >/dev/null
if [ "\$?" -ne 0 ]
then
    dbeng50 xvsb.db >/dev/null &
fi
EOM


cp $XVISRUN_SH t1.sh

cat << EOM > xv.sh
"\$${XVOEM}VISION_33/xvision"
EOM

cat << EOM > sm.sh
if [ "\${XVHOST}" = "unknown" -o "\${XVIPADD}" = "unknown" ]
then
    \$${XVOEM}VISION_33/switchmanager
else
    \$${XVOEM}VISION_33/switchmanager -OV=\$XVHOST,\$XVIPADD,\$XVGETPW,\$XVSETPW
fi

EOM


cat << EOM > done.sh
ps -ea | grep xvis | grep ion >/dev/null
if [ "\$?" -ne 0 ]
then
    ps -ea | grep switch | grep ma >/dev/null
    if [ "\$?" -ne 0 ]
    then
        ps -ea | grep dbeng5  | awk '{print "kill -TERM " \$1}' | sh >/dev/null 2>&1
        chmod 777 xvsb.db >/dev/null 2>&1
    fi
fi
EOM


cat t1.sh sm.sh done.sh > $XVISSM_SH
cat t1.sh xv.sh done.sh > $XVISRUN_SH

chmod 555 $XVISRUN_SH
chmod u+s $XVISRUN_SH
cp $XVISRUN_SH $USERDIR
chmod 555 ${USERDIR}/$XVISRUN_SH
chmod u+s ${USERDIR}/$XVISRUN_SH

chmod 555 $XVISSM_SH
chmod u+s $XVISSM_SH
cp $XVISSM_SH $USERDIR
chmod 555 ${USERDIR}/$XVISSM_SH
chmod u+s ${USERDIR}/$XVISSM_SH

cat << EOM > $XVISLAUNCH_SH
#!/bin/sh
#
# $XVOEMXV 3.3 - Calls nmlaunch with appropriate parameters.
#

${XVOEM}VISION_33=$XVISION_33
export ${XVOEM}VISION_33

XVDEVICE=\$1
XVOPTIONS=""
while [ "\$#" -gt 1 ]
do
    shift 
    XVOPTIONS=\`echo \$XVOPTIONS \$1\`
done

$DYNLIBPATH=\$${XVOEM}VISION_33:$WINDU_XMLIB_DIR:$WINDU_XLIB_DIR:/usr/openwin/lib:/usr/dt/lib:/usr/lib/X11R6:/usr/lib/X11R4:/usr/lib:/opt/OV/lib:\$$DYNLIBPATH
export $DYNLIBPATH

cd \$${XVOEM}VISION_33
\$${XVOEM}VISION_33/nmlaunch \$XVDEVICE \$XVOPTIONS "\$${XVOEM}VISION_33/$XVISSM_SH"

EOM

chmod 555 $XVISLAUNCH_SH
chmod u+s $XVISLAUNCH_SH
cp $XVISLAUNCH_SH $USERDIR
chmod 555 ${USERDIR}/$XVISLAUNCH_SH
chmod u+s ${USERDIR}/$XVISLAUNCH_SH


ExitMsg
